<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Testimonials_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'testimonials_widget';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonials Widget', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'testimonials_widget',
			[
				'label' => esc_html__( 'Testimonials Widget', 'dogri-elementor' ),
			]
		);		

		$this->add_control(
			'image',
				[
				  'label' => __( 'Image', 'dogri-elementor' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
		);	
		
		$this->add_control(
			'alt_text',
			[
				'label'       => __( 'Alt text', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Description', 'dogri-elementor' ),
			]
		);
		
		$this->end_controls_section();

		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'seperator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
															

								'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],
								
								'block_subtitle' =>
								[
									'name' => 'block_subtitle',
									'label' => esc_html__('Sub Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								'block_title1' =>
								[
									'name' => 'block_title1',
									'label' => esc_html__('Author Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								'block_image' =>
								[
									'name' => 'block_image',
									'label' => __( 'Image', 'dogri-elementor' ),
									'type' => Controls_Manager::MEDIA,
									'default' => ['url' => Utils::get_placeholder_image_src(),],
								],	

								'block_alt_text' =>
								[
								'name' => 'block_alt_text',
								'label' => esc_html__('Image Text', 'dogri-elementor'),
								'type' => Controls_Manager::TEXTAREA,
								'default' => esc_html__('', 'dogri-elementor')
								],

								'block_image1' =>
								[
									'name' => 'block_image1',
									'label' => __( 'Image', 'dogri-elementor' ),
									'type' => Controls_Manager::MEDIA,
									'default' => ['url' => Utils::get_placeholder_image_src(),],
								],	

								'block_alt_text1' =>
								[
								'name' => 'block_alt_text1',
								'label' => esc_html__('Image Text', 'dogri-elementor'),
								'type' => Controls_Manager::TEXTAREA,
								'default' => esc_html__('', 'dogri-elementor')
								],

								'block_text' =>
								[
									'name' => 'block_text',
									'label' => esc_html__('Rating', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								'block_text1' =>
								[
									'name' => 'block_text1',
									'label' => esc_html__('Text', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	

	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//put the js code under this line 

if ($(".testimonial-carousel").length) {
	$(".testimonial-carousel").owlCarousel({
	  loop: true,
	  margin: 25,
	  nav: false,
	  dots: false,
	  smartSpeed: 500,
	  autoplay: 1000,
	  responsive: {
		0: {
		  items: 1
		},
		480: {
		  items: 1
		},
		600: {
		  items: 1
		},
		800: {
		  items: 1
		},
		1200: {
		  items: 1
		}

	  }
	});
  }

//put the code above the line 

  });
</script>';


?>

<!-- Testimonial -->
<section class="testimonial-section"> 
    <div class="dogri-container">
        <div class="row g-4">
            <div class="col-lg-6">                
                <div class="parallax-scene-2">   
                    <div data-depth="0.5">
                        <figure class="image" data-aos="fade-left" data-aos-duration="1000">
						<?php  if ( !empty(esc_url($settings['image']['id']) )) : ?>   
							<img src="<?php echo wp_get_attachment_url($settings['image']['id']);?>" alt="<?php echo esc_attr($settings['alt_text']);?>"/>
						<?php endif;?>
                        </figure>                       
                    </div>                                  
                </div>
            </div>
            <div class="col-lg-6">
                <div class="testimonial-carousel owl-carousel owl-theme" data-aos="fade-right" data-aos-duration="1000">
                    <!-- block -->
					<?php foreach($settings['repeat'] as $item):?>
                    <div class="testimonials">
                        <div class="title-box text-center">
                            <h4 class="sec-sub-title"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?> </h4>
                            <h2 class="sec-title"><?php echo wp_kses($item['block_title'], $allowed_tags);?></h2>                  
                        </div>
                        <div class="content text-center position-relative">
                            <div class="reviwer">
                                <div class="reviewer-img">
								<?php if(!empty(wp_get_attachment_url($item['block_image']['id']))): ?>
									<img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
								<?php endif;?>
                                </div>
                                <div class="icon-1">
								<?php if(!empty(wp_get_attachment_url($item['block_image1']['id']))): ?>
									<img src="<?php echo wp_get_attachment_url($item['block_image1']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text1'], $allowed_tags);?>">
								<?php endif;?>
                                </div>
                                <h4><?php echo wp_kses($item['block_title1'], $allowed_tags);?></h4>
                                <ul class="rating">
									<?php echo wp_kses($item['block_text'], $allowed_tags);?>
                                </ul>
                                <p><?php echo wp_kses($item['block_text1'], $allowed_tags);?></p>
                            </div>
                        </div>
                    </div>
					<?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Testimonial End -->
             




		<?php 
	}


}
